package gov.va.med.mhv.usermgmt.data.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Type;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;

@Entity
@Table(name = "ACTIVITY")
public class Activity extends AbstractBaseEntity {
	private static final long serialVersionUID = 752388229562277991L;
 
	@Id
	@Column(name = "ACTIVITY_ID")	
	@GeneratedValue(strategy = GenerationType.AUTO) 
 	private Long activityId;
	
	@Column(name = "USER_PROFILE_ID" )
	private Long userProfileId;

	@Column(name = "ACTION")
	private String action;
	
	@Column(name = "STATUS", columnDefinition = "NUMBER" )
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean status;
	
	@Column(name = "PERFORMER_TYPE")
 	private String performerType;
 
	@Column(name = "ACTIVITY_TYPE")
	private String activityType;
  
	@Column(name = "DETAIL_VALUE")
 	private String detailValue;

	@Column(name = "COMPLETION_TIME")
	@Temporal(TemporalType.TIMESTAMP)
 	private Date completionTime;

	public Long getActivityId() {
		return activityId;
	}

	public void setActivityId(Long activityId) {
		this.activityId = activityId;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public Boolean getStatus() {
		return status;
	}

	public void setStatus(Boolean status) {
		this.status = status;
	}

	public String getPerformerType() {
		return performerType;
	}

	public void setPerformerType(String performerType) {
		this.performerType = performerType;
	}

	public String getActivityType() {
		return activityType;
	}

	public void setActivityType(String activityType) {
		this.activityType = activityType;
	}

	public String getDetailValue() {
		return detailValue;
	}

	public void setDetailValue(String detailValue) {
		this.detailValue = detailValue;
	}

	public Date getCompletionTime() {
		return completionTime;
	}

	public void setCompletionTime(Date completionTime) {
		this.completionTime = completionTime;
	}
}
